#include "General.h"

Player_t* Player::Data[128];

void Player::Load()
{
	for (int i = 0; i < 127; i++)
	{
		Player::Data[i] = new Player_t;
		memset(Player::Data[i], 0x0, sizeof(Player_t)); // Can cause crash on load
//		Player::Data[i]->PlayerId = 0;
//		Player::Data[i] = 0;
	}
}

void Player::Unload()
{
	if (Player::Data)
	{
		for (int i = 0; i < 127; i++)
		{
			if(Player::Data[i] != 0)
			{
				delete Player::Data[i];
			}
		}
//		delete Player::Data;
	}
}

void Player::On_Player_Join(int ID)
{
	DLOG;
	const char *Nick = Get_Player_Name_By_ID(ID);

	Player_t* p = Player::Data[ID];

	p->PlayerId = ID;
	p->Nick = Nick;
	p->Serial = Get_Client_Serial_Hash(ID);
	p->Address = "";
	
	p->Muted = false;
	p->Access = "p";
	p->Shunned = false;
	p->BlockBeacons = false;

	Console_Output("Nick = %s, Serial = %s\n", p->Nick, p->Serial);
//	delete []Nick;
}

void Player::On_Player_Leave(int ID)
{
	memset(Player::Data[ID], 0x0, sizeof(Player_t));
}

void Player::MapLoad()
{
}

Player_t *Player::Get(int ID)
{
	DLOG;

	if(ID < 1 || ID > 127) 
	{ 
		return 0; 
	}
	if(!Player::Data[ID])
	{
		return 0;
	}
	return Player::Data[ID];
}

/* Player_t* Player::Get(const char* PlayerName)
{

	Player::Get(Get_Player_ID
} */